<?php
if( Auth::check() ) {

	// FOLLOW ACTIVE
 	$followActive = App\Models\Followers::where( 'follower', Auth::user()->id )
 	->where('following',$response->user()->id)
	->where('status', '1')
 	->first();

       if( $followActive ) {
       	  $textFollow   = trans('users.following');
		  $icoFollow    = '-ok';
		  $activeFollow = 'btnFollowActive';
       } else {
       		$textFollow   = trans('users.follow');
		    $icoFollow    = '-plus';
			$activeFollow = '';
       }

	   // LIKE ACTIVE
	   $likeActive = App\Models\Like::where( 'user_id', Auth::user()->id )
	   ->where('images_id',$response->id)
	   ->where('status','1')
	   ->first();

       if( $likeActive ) {
       	  $textLike   = trans('misc.unlike');
		  $icoLike    = 'fa fa-heart';
		  $statusLike = 'active';
       } else {
       		$textLike   = trans('misc.like');
		    $icoLike    = 'fa fa-heart-o';
			$statusLike = '';
       }

	   // ADD TO COLLECTION
	   $collections = App\Models\Collections::where('user_id',Auth::user()->id)->orderBy('id','asc')->get();

 }//<<<<---- *** END AUTH ***

	// All Images resolutions
	$stockImages = $response->stock;

	// Similar Photos
	$arrayTags  = explode(",",$response->tags);
	$countTags = count( $arrayTags );

	$images = App\Models\Images::where('categories_id',$response->categories_id)
	->whereStatus('active')
	->where(function($query) use ($arrayTags,$countTags){
		for( $k = 0; $k < $countTags; ++$k ){
			 $query->orWhere('tags', 'LIKE', '%'.$arrayTags[$k].'%');
		}
	} )
	->where('id', '<>',$response->id)
	->orderByRaw('RAND()')
	->take(5)
	->get();

	// Comments
	$comments_sql = $response->comments()->where('status','1')->orderBy('date', 'desc')->paginate(10);

 ?>
 

<?php $__env->startSection('title'); ?><?php echo e($response->title.' - '.trans_choice('misc.photos_plural', 1 ).' #'.$response->id.' - '); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('description_custom'); ?><?php echo e($response->title.' - '.trans_choice('misc.photos_plural', 1 ).' #'.$response->id.' - '); ?> <?php if( $response->description != '' ): ?><?php echo e(App\Helper::removeLineBreak( e( $response->description ) ).' - '); ?><?php endif; ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('keywords_custom'); ?><?php echo e($response->tags .','); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link href="<?php echo e(asset('public/plugins/iCheck/all.css')); ?>" rel="stylesheet" type="text/css" />

<meta property="og:site_name" content="<?php echo e($settings->title); ?>"/>
<meta property="og:url" content="<?php echo e(url("photo/$response->id").'/'.str_slug($response->title)); ?>"/>
<meta property="og:image" content="<?php echo e(asset('public/uploads/preview/')); ?>/<?php echo e($response->preview); ?>"/>

<meta property="og:title" content="<?php echo e($response->title); ?>"/>
<meta property="og:description" content="<?php echo e(App\Helper::removeLineBreak( e( $response->description ) )); ?>"/>

<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:image" content="<?php echo e(asset('public/uploads/preview/')); ?>/<?php echo e($response->preview); ?>" />
<meta name="twitter:title" content="<?php echo e($response->title); ?>" />
<meta name="twitter:description" content="<?php echo e(App\Helper::removeLineBreak( e( $response->description ) )); ?>"/>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if( Auth::check() ): ?>
<div class="modal fade" id="collections" tabindex="-1" role="dialog" aria-hidden="true">
     		<div class="modal-dialog modal-sm">
     			<div class="modal-content">
     				<div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
				        <h4 class="modal-title text-center" id="myModalLabel">
				        	<strong><?php echo e(trans('misc.add_collection')); ?></strong>
				        	</h4>
				     </div><!-- Modal header -->

			<div class="modal-body listWrap">

			<div class="collectionsData">
				<?php if( $collections->count() != 0 ): ?>
				    <?php $__currentLoopData = $collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $collection): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>

				     <?php

				     $collectionImages = $collection->collection_images->where('images_id',$response->id)->where('collections_id',$collection->id)->first();

					 if( !empty( $collectionImages ) ) {
						$checked = 'checked="checked"';
						} else {
							$checked = null;
						}
				     ?>
				     	<div class="radio margin-bottom-15">
							<label class="checkbox-inline padding-zero addImageCollection text-overflow" data-image-id="<?php echo e($response->id); ?>" data-collection-id="<?php echo e($collection->id); ?>">
							<input class="no-show" name="checked" <?php echo e($checked); ?> type="checkbox" value="true">
							<span class="input-sm"><?php echo e($collection->title); ?></span>
							</label>
						</div>

				    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>



				    <?php else: ?>
				    	<div class="btn-block text-center no-collections"><?php echo e(trans('misc.no_have_collections')); ?></div>
				    <?php endif; ?>

          </div><!-- collection data -->

          <small class="btn-block note-add <?php if( $collections->count() == 0 ): ?> display-none <?php endif; ?>">* <?php echo e(trans('misc.note_add_collections')); ?></small>

          <span class="label label-success display-none btn-block response-text"></span>

                 <!-- form start -->
			    <form method="POST" action="" enctype="multipart/form-data" id="addCollectionForm">
			    	<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
			    	<input type="hidden" name="image_id" value="<?php echo e($response->id); ?>">

                 <!-- Start Form Group -->
                    <div class="form-group">
                      <label><?php echo e(trans('admin.title')); ?></label>
                        <input type="text" value="" name="title" id="titleCollection" class="form-control" placeholder="<?php echo e(trans('admin.title')); ?>">
                    </div><!-- /.form-group-->

                    <!-- Start form-group -->
                    <div class="form-group">

                      	<div class="radio">
                        <label class="padding-zero">
                          <input type="radio" name="type" checked="checked" value="public">
                          <?php echo e(trans('misc.public')); ?>

                        </label>
                      </div>

                      <div class="radio">
                        <label class="padding-zero">
                          <input type="radio" name="type" value="private">
                          <?php echo e(trans('misc.private')); ?>

                        </label>
                      </div>

                    </div><!-- /.form-group -->

                    <!-- Alert -->
                    <div class="alert alert-danger alert-small display-none" id="dangerAlert">
							<ul class="list-unstyled" id="showErrors"></ul>
						</div><!-- Alert -->

                 <div class="btn-block text-center">
                 	<button type="submit" class="btn btn-sm btn-success" id="addCollection"><?php echo e(trans('misc.create_collection')); ?> <i class="fa fa-plus"></i></button>
                 </div>

                    </form>

				      </div><!-- Modal body -->
     				</div><!-- Modal content -->
     			</div><!-- Modal dialog -->
     		</div><!-- Modal -->
     		<?php endif; ?>

<div class="container margin-bottom-40 padding-top-40">

<!-- Col MD -->
<div class="col-md-9">

	<?php if( $response->status == 'pending' ): ?>
	<div class="alert alert-warning" role="alert">
			<i class="glyphicon glyphicon-info-sign myicon-right"></i>  <?php echo e(trans('misc.pending_approval')); ?>

		</div>
		<?php endif; ?>

	<div class="text-center margin-bottom-20">
		<img class="img-responsive" style="display: inline-block;" src="<?php echo e(url('public/uploads/preview',$response->preview)); ?>" />
	</div>

	<h1 class="class-montserrat title-image none-overflow">
	 <?php echo e($response->title); ?>

	</h1>

 <hr />

<?php if( $response->description != '' ): ?>
<p class="description">
	<?php echo e($response->description); ?>

</p>
<?php endif; ?>

<!-- Start Block -->
<div class="btn-block margin-bottom-20">
	<h3><?php echo e(trans('misc.tags')); ?></h3>
	<?php
	   $tags = explode(',', $response->tags);
	   $count_tags = count( $tags );
	   ?>

	   <?php for( $i = 0; $i < $count_tags; ++$i ): ?>
	   <a href="<?php echo e(url('tags',$tags[$i])); ?>" class="btn btn-danger tags font-default btn-sm">
	   	<?php echo e($tags[$i]); ?>

	   </a>
	   <?php endfor; ?>
</div><!-- End Block -->

<?php if( $images->count() != 0 ): ?>
<!-- Start Block -->
<div class="btn-block margin-bottom-20 po">
	<h3><?php echo e(trans('misc.similar_photos')); ?></h3>
	<div id="imagesFlex" class="flex-images btn-block margin-bottom-40">
		<?php echo $__env->make('includes.images', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		</div>
</div><!-- End Block -->
<?php endif; ?>

<!-- Start Block -->
<div class="btn-block margin-bottom-20">
	<h3><?php echo e(trans('misc.comments')); ?>(<span id="totalComments"><?php echo e(number_format( $response->comments()->count() )); ?></span>)</h3>


	<?php if( Auth::check() && $response->status == 'pending' ): ?>
	<div class="alert alert-warning" role="alert">
			<i class="glyphicon glyphicon-info-sign myicon-right"></i>  <?php echo e(trans('misc.pending_approval')); ?>

		</div>
		<?php endif; ?>

<?php if( Auth::check() && $response->status == 'active' ): ?>


	<div class="media">
            <span class="pull-left">
                <img alt="Image" src="<?php echo e(asset('public/avatar')); ?>/<?php echo e(Auth::user()->avatar); ?>" class="media-object img-circle" width="50">
            </span>

            <div class="media-body">
            <form action="<?php echo e(url('comment/store')); ?>" method="post" id="commentsForm">
            	<div class="form-group text-form">
            		<input type="hidden" name="image_id" value="<?php echo e($response->id); ?>" />
            		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
            		<textarea name="comment" rows="3" required="required" min="2" id="comments" class="form-control input-sm textarea-comments mentions-textarea"></textarea>
            	</div>

            	<!-- Alert -->
                    <div class="alert alert-danger alert-small display-none" id="dangerAlertComments">
							<ul class="list-unstyled" id="showErrorsComments"></ul>
						</div><!-- Alert -->

                <div class="form-group ">
                	<button type="submit" class="btn btn-success btn-lg custom-rounded" id="commentSend"><?php echo e(trans('auth.send')); ?> <i class="fa fa-paper-plane"></i></button>
                	<small class="pull-right text-muted"><?php echo e($settings->comment_length); ?></small>
                </div>
                </form>
            </div><!-- media body -->
 </div><!-- media -->
 <hr />
 <?php endif; ?>


	<div class="gridComments" id="gridComments" style="padding-top: 15px;">
		<?php echo $__env->make('includes.comments', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	</div><!-- gridComments -->

	 <?php if( $comments_sql->count() == 0 ): ?>

   <div class="btn-block text-center noComments">
	    	<i class="icon icon-MessageRight ico-no-result"></i>
	    </div>

    		<h3 class="margin-top-none text-center no-result row-margin-20 noComments">
	    	<?php echo e(trans('misc.no_comments_yet')); ?>

	    	</h3>
	    	<?php endif; ?>

	 <?php if( Auth::guest() ): ?>
	 <hr />
	 	<div class="alert alert-loggin text-center alert-custom" role="alert">
	 		<?php echo e(trans('auth.logged_in_comments')); ?>


	 	<?php if( $settings->registration_active == '1' ): ?>
	 		<a href="<?php echo e(url('register')); ?>" class="btn btn-xs btn-success"><?php echo e(trans('auth.sign_up')); ?></a>
	 	<?php endif; ?>

	 	<a href="<?php echo e(url('login')); ?>"><?php echo e(trans('auth.login')); ?></a>

	 	</div>
	 <?php endif; ?>

</div><!-- End Block -->

 </div><!-- /COL MD -->

 <div class="col-md-3">

 	<?php if( Auth::check() &&  isset($response->user()->id) && Auth::user()->id == $response->user()->id ): ?>
 	<div class="row margin-bottom-20">

			<div class="col-md-12">
				<a class="btn btn-success btn-block margin-bottom-5" href="<?php echo e(url('edit/photo',$response->id)); ?>"><i class="fa fa-pencil myicon-right "></i> <?php echo e(trans('admin.edit')); ?></a>
			</div>
			<div class="col-md-12">
				<a href="#" class="btn btn-danger btn-block" id="deletePhoto" data-url="<?php echo e(url('delete/photo',$response->id)); ?>"><i class="fa fa-times-circle myicon-right "></i> <?php echo e(trans('admin.delete')); ?></a>
			</div>
		</div>
		<?php endif; ?>

 	<!-- Start Panel -->
 	<div class="panel panel-default">
	  <div class="panel-body">
	    <div class="media none-overflow">
			  <div class="media-left">
			    <a href="<?php echo e(url($response->user()->username)); ?>">
			      <img class="media-object img-circle" src="<?php echo e(url('public/avatar/',$response->user()->avatar)); ?>" width="50" height="50" >
			    </a>
			  </div>
			  <div class="media-body">
			  	<a href="<?php echo e(url($response->user()->username)); ?>" class="text-username font-default">
			    	<h4 class="media-heading"><?php echo e($response->user()->username); ?></h4>
			    </a>
			    <small class="media-heading text-muted btn-block margin-zero"><?php echo e(trans('misc.published')); ?> <?php echo e(App\Helper::formatDate($response->date)); ?></small>
			    <small class="media-heading text-muted"><?php echo e(number_format(App\Models\User::totalImages( $response->user()->id))); ?> <?php echo e(trans_choice('misc.images_plural', App\Models\User::totalImages( $response->user()->id ))); ?></small>
			   
			  </div>
			</div>
	  </div>
	</div><!-- End Panel -->

<?php if( Auth::check() && $response->status == 'active'): ?>
<div class="row margin-bottom-20">

	<!-- col-xs-6 -->
	<div class="col-xs-6" style="border-right: 1px solid #e3e3e3;">
	<?php if( Auth::check()  ): ?>
		<a href="#" class="btnLike likeButton <?php echo e($statusLike); ?>" data-id="<?php echo e($response->id); ?>" data-like="<?php echo e(trans('misc.like')); ?>" data-unlike="<?php echo e(trans('misc.unlike')); ?>">
			<h3 class="btn-block text-center margin-top-10"><i class="<?php echo e($icoLike); ?>"></i></h3>
			<small class="btn-block text-center text-muted textLike"><?php echo e($textLike); ?></small>
		</a>
		<?php else: ?>

		<a href="<?php echo e(url('login')); ?>" class="btnLike">
			<h3 class="btn-block text-center margin-top-10"><i class="fa fa-heart-o"></i></h3>
			<small class="btn-block text-center text-muted"><?php echo e(trans('misc.like')); ?></small>
		</a>

		<?php endif; ?>
	</div><!-- col-xs-6 -->


		 <!-- col-xs-6 -->
		<div class="col-xs-6">
		<?php if( Auth::check() ): ?>

			<a href="#" class="btn-collection" data-toggle="modal" data-target="#collections">
				<h3 class="btn-block text-center margin-top-10"><i class="fa fa-folder-open-o"></i></h3>
			    <small class="btn-block text-center text-muted"><?php echo e(trans('misc.collection')); ?></small>
		    </a>

		    <?php else: ?>

		    <a href="<?php echo e(url('login')); ?>" class="btn-collection">
				<h3 class="btn-block text-center margin-top-10"><i class="fa fa-folder-open-o"></i></h3>
			    <small class="btn-block text-center text-muted"><?php echo e(trans('misc.collection')); ?></small>
		    </a>

		    <?php endif; ?>
		</div><!-- col-xs-6 -->
</div>
<?php endif; ?>


	<!-- Start Panel -->
 	<div class="panel panel-default">
	  <div class="panel-body padding-zero">
	  		<ul class="list-stats list-inline">
	    	<li>
	    		<h4 class="btn-block text-center"><?php echo e(App\Helper::formatNumber($response->visits()->count())); ?></h4>
	    		<small class="btn-block text-center text-muted"><?php echo e(trans('misc.views')); ?></small>
	    	</li>

	    	<li>
	    		<h4 class="btn-block text-center" id="countLikes"><?php echo e(App\Helper::formatNumber($response->likes()->count())); ?></h4>
	    		<small class="btn-block text-center text-muted"><?php echo e(trans('misc.likes')); ?></small>
	    	</li>

	    	<li>
	    		<h4 class="btn-block text-center"><?php echo e(App\Helper::formatNumber($response->downloads()->count())); ?></h4>
	    		<small class="btn-block text-center text-muted"><?php echo e(trans('misc.downloads')); ?></small>
	    	</li>

	    </ul>

	  </div>
	</div><!-- End Panel -->

	<?php if( $response->featured == 'yes' ): ?>

	<!-- Start Panel -->
	<div class="panel panel-default">
		<div class="panel-body">
	<i class="icon icon-Medal myicon-right"></i> <span class="text-muted"><?php echo e(trans('misc.featured_on')); ?> </span>
	<strong><?php echo e(App\Helper::formatDate($response->featured_date)); ?></strong>

		</div>
	</div><!-- End Panel -->

	<?php endif; ?>

	<div class="btn-group btn-block margin-bottom-20">

		<button type="button" class="btn btn-success btn-lg btn-block dropdown-toggle" id="downloadBtn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
			<i class="fa fa-cloud-download myicon-right"></i> <?php echo e(trans('misc.download')); ?> <span class="caret"></span>
			</button>

		 <ul class="dropdown-menu arrowDownload dd-close btn-block">
		 	<?php $__currentLoopData = $stockImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
		 	<?php
		 	switch( $stock->type ) {
			case 'small':
				$_size          = trans('misc.s');
				break;
			case 'medium':
				$_size          = trans('misc.m');
				break;
			case 'large':
				$_size          = trans('misc.l');
				break;

		}
		 	 ?>
		    	<li><a href="<?php echo e(url('download',$stock->token)); ?>/<?php echo e($stock->type); ?>"><span class="label label-default myicon-right"><?php echo e($_size); ?></span> <?php echo e($stock->resolution); ?> <span class="pull-right"><?php echo e($stock->size); ?></span></a></li>
		    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
		  </ul>
		</div>

	<?php
	switch( $response->how_use_image ) {
			case 'free':
				$license          = trans('misc.use_free');
				$iconLicense      = 'glyphicon glyphicon-ok';
				break;
			case 'free_personal':
				$license          = trans('misc.use_free_personal');
				$iconLicense      = 'icon-warning';
				break;
			case 'editorial_only':
				$license          = trans('misc.use_editorial_only');
				$iconLicense      = 'icon-warning';
				break;
			case 'web_only':
				$license          = trans('misc.use_web_only');
				$iconLicense      = 'icon-warning';
				break;
		}
 ?>
	<!-- Start Panel -->
	<div class="panel panel-default">
		<div class="panel-body">
			<h5><i class="fa fa-creative-commons myicon-right" aria-hidden="true"></i> <strong><?php echo e(trans('misc.license_and_use')); ?></strong></h5>
			<small class="text-muted"><i class="<?php echo e($iconLicense); ?> myicon-right"></i> <?php echo e($license); ?></small>

			<?php if( $response->attribution_required == 'yes' ): ?>
			<small class="btn-block text-muted"><i class="glyphicon glyphicon-ok myicon-right"></i> <?php echo e(trans('misc.attribution_required')); ?></small>
			<?php else: ?>
			<small class="btn-block text-muted"><i class="glyphicon glyphicon-remove myicon-right"></i> <?php echo e(trans('misc.no_attribution_required')); ?></small>
			<?php endif; ?>

		</div>
	</div><!-- End Panel -->

	<?php if( $response->status == 'active' ): ?>
		<!-- Start Panel -->
	<div class="panel panel-default">
		<div class="panel-body">
			<h5 class="pull-left margin-zero" style="line-height: inherit;"><i class="icon icon-Share myicon-right" aria-hidden="true"></i> <strong><?php echo e(trans('misc.share')); ?></strong></h5>

		<ul class="list-inline pull-right margin-zero">
			<div class="bdsharebuttonbox"><a href="#" class="bds_more" data-cmd="more"></a><a href="#" class="bds_qzone" data-cmd="qzone" title="分享到QQ空间"></a><a href="#" class="bds_tsina" data-cmd="tsina" title="分享到新浪微博"></a><a href="#" class="bds_weixin" data-cmd="weixin" title="分享到微信"></a></div>
<script>window._bd_share_config={"common":{"bdSnsKey":{},"bdText":"","bdMini":"2","bdMiniList":false,"bdPic":"","bdStyle":"1","bdSize":"24"},"share":{}};with(document)0[(getElementsByTagName('head')[0]||body).appendChild(createElement('script')).src='/static/api/js/share.js?v=89860593.js?cdnversion='+~(-new Date()/36e5)];</script>
     </ul>
		</div>
	</div><!-- End Panel -->
	<?php endif; ?>

	<?php if( $response->exif != '' || $response->camera != '' ): ?>
	<!-- Start Panel -->
	<div class="panel panel-default">
		<div class="panel-body">
			<h5><i class="icon icon-DSLRCamera myicon-right" aria-hidden="true"></i> <strong><?php echo e(trans('misc.exif_data')); ?></strong></h5>

			<?php if( $response->camera != ''  ): ?>
			<small class="btn-block text-muted"><?php echo e(trans('misc.photo_taken_with')); ?></small>
			<small class="btn-block text-muted"><a href="<?php echo e(url('cameras',$response->camera)); ?>"><?php echo e($response->camera); ?></a></small>
			<?php endif; ?>

			<small class="btn-block text-muted wordSpacing"><?php echo e($response->exif); ?></small>

		</div>
	</div><!-- End Panel -->
	<?php endif; ?>

	<?php if( $response->colors != '' ): ?>
	<?php
       $colors = explode(',', $response->colors);
       $count_colors = count( $colors );
       ?>

	<!-- Start Panel -->
	<div class="panel panel-default">
		<div class="panel-body">
			<h5><i class="icon icon-Drop myicon-right" aria-hidden="true"></i> <strong><?php echo e(trans('misc.color_palette')); ?></strong></h5>

			<?php for( $c = 0; $c < $count_colors; ++$c ): ?>

		   	<a title="#<?php echo e($colors[$c]); ?>" href="<?php echo e(url('colors')); ?>/<?php echo e($colors[$c]); ?>" class="colorPalette showTooltip" style="background-color: <?php echo e('#'.$colors[$c]); ?>;"></a>

		   	<?php endfor; ?>

		</div>
	</div><!-- End Panel -->
	<?php endif; ?>

<ul class="list-group">
       <li class="list-group-item"><i class="icon-info myicon-right"></i> <strong><?php echo e(trans('misc.details')); ?></strong></li>


       <li class="list-group-item"> <span class="badge data-xs-img"><?php echo e(App\Helper::formatDate($response->date)); ?></span> <?php echo e(trans('misc.published')); ?></li>
	  <li class="list-group-item"> <span class="badge data-xs-img"><?php echo e(strtoupper($response->extension)); ?></span> <?php echo e(trans('misc.image_type')); ?></li>
	  <li class="list-group-item"> <span class="badge data-xs-img"><?php echo e($stockImages{2}->resolution); ?></span> <?php echo e(trans('misc.resolution')); ?></li>
	  <li class="list-group-item"> <span class="badge data-xs-img"><a href="<?php echo e(url('category',$response->category->slug)); ?>" title="<?php echo e($response->category->name); ?>"><?php echo e(str_limit($response->category->name, 18, '...')); ?></a></span> <?php echo e(trans('misc.category')); ?></li>
	  <li href="#" class="list-group-item"> <span class="badge data-xs-img"><?php echo e($stockImages{2}->size); ?></span> <?php echo e(trans('misc.file_size')); ?></li>
	</ul>


<?php if( Auth::check() ): ?>
<div class="modal fade" id="reportImage" tabindex="-1" role="dialog" aria-hidden="true">
     		<div class="modal-dialog modal-sm">
     			<div class="modal-content">
     				<div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
				        <h4 class="modal-title text-center" id="myModalLabel">
				        	<strong><?php echo e(trans('misc.report_photo')); ?></strong>
				        	</h4>
				     </div><!-- Modal header -->

				      <div class="modal-body listWrap">

				    <!-- form start -->
			    <form method="POST" action="<?php echo e(url('report/photo')); ?>" enctype="multipart/form-data" id="formReport">
			    	<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
			    	<input type="hidden" name="id" value="<?php echo e($response->id); ?>">
				    <!-- Start Form Group -->
                    <div class="form-group">
                      <label><?php echo e(trans('admin.reason')); ?></label>
                      	<select name="reason" class="form-control">
                            <option value="copyright"><?php echo e(trans('admin.copyright')); ?></option>
                            <option value="privacy_issue"><?php echo e(trans('admin.privacy_issue')); ?></option>
                            <option value="violent_sexual_content"><?php echo e(trans('admin.violent_sexual_content')); ?></option>
                          </select>

                  </div><!-- /.form-group-->

                   <button type="submit" class="btn btn-sm btn-danger" id="reportPhoto"><?php echo e(trans('misc.report_photo')); ?></button>

                    </form>

				      </div><!-- Modal body -->
     				</div><!-- Modal content -->
     			</div><!-- Modal dialog -->
     		</div><!-- Modal -->
     		<?php endif; ?>

<?php if( Auth::check() && Auth::user()->id != $response->user()->id && $response->status == 'active' ): ?>
	<div class="btn-block text-center">
		<a href="#" data-toggle="modal" data-target="#reportImage"><i class="icon-warning myicon-right"></i> <?php echo e(trans('misc.report_photo')); ?></a>
	</div>
	<?php endif; ?>

	<?php if( isset( $settings->google_adsense ) ): ?>
	<div class="margin-top-20">
	   <?php echo html_entity_decode($settings->google_adsense); ?>
	</div>
	<?php endif; ?>

 </div><!-- /COL MD -->

 </div><!-- container wrap-ui -->

 <?php if( Auth::check() && $response->user()->id != Auth::user()->id && $response->user()->paypal_account != '' || Auth::guest()  && $response->user()->paypal_account != '' ): ?>
 <form id="form_pp" name="_xclick" action="https://www.paypal.com/cgi-bin/webscr" method="post"  style="display:none">
    <input type="hidden" name="cmd" value="_donations">
    <input type="hidden" name="return" value="<?php echo e(url('photo',$response->id)); ?>">
    <input type="hidden" name="cancel_return"   value="<?php echo e(url('photo',$response->id)); ?>">
    <input type="hidden" name="currency_code" value="USD">
    <input type="hidden" name="item_name" value="<?php echo e(trans('misc.support').' @'.$response->user()->username); ?> - <?php echo e($settings->title); ?>" >
    <input type="hidden" name="business" value="<?php echo e($response->user()->paypal_account); ?>">
    <input type="submit">
</form>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('public/plugins/iCheck/icheck.min.js')); ?>" type="text/javascript"></script>
<script type="text/javascript">

$('#imagesFlex').flexImages({ maxRows: 1, truncate: true });

$('#btnFormPP').click(function(e){
	$('#form_pp').submit();
});

$('input').iCheck({
          radioClass: 'iradio_flat-green',
          checkboxClass: 'icheckbox_square-green',
        });

<?php if(session('noty_error')): ?>
    		swal({
    			title: "<?php echo e(trans('misc.error_oops')); ?>",
    			text: "<?php echo e(trans('misc.already_sent_report')); ?>",
    			type: "error",
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>"
    			});
   		 <?php endif; ?>

   		 <?php if(session('noty_success')): ?>
    		swal({
    			title: "<?php echo e(trans('misc.thanks')); ?>",
    			text: "<?php echo e(trans('misc.send_success')); ?>",
    			type: "success",
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>"
    			});
   		 <?php endif; ?>

  <?php if( Auth::check() ): ?>

  $("#reportPhoto").click(function(e) {
  	var element     = $(this);
	e.preventDefault();
  	 element.attr({'disabled' : 'true'});

  	 $('#formReport').submit();

  });

  // Comments Delete
$(document).on('click','.deleteComment',function () {

	var $id = $(this).data('id');

	$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
			});

		swal(
			{   title: "<?php echo e(trans('misc.delete_confirm')); ?>",
			  type: "warning",
			  showLoaderOnConfirm: true,
			  showCancelButton: true,
			  confirmButtonColor: "#DD6B55",
			   confirmButtonText: "<?php echo e(trans('misc.yes_confirm')); ?>",
			   cancelButtonText: "<?php echo e(trans('misc.cancel_confirm')); ?>",
			    closeOnConfirm: false,
			    },
			    function(isConfirm){
			    	 if (isConfirm) {

			element = $(this);

			element.removeClass('deleteComment');

			$.post("<?php echo e(url('comment/delete')); ?>",
			{ comment_id: $id },
			function(data){
				if(data.success == true ){
					window.location.reload();
				} else {
					//bootbox.alert(data.error);
					//window.location.reload();
				}

			},'json');

			   }
	       });
		});

  // Likes Comments
		$(document).on('click','.likeComment',function () {

			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
			});

			element  = $(this);

			element.html('<i class="fa fa-spinner fa-spin"></i>');

			$.post("<?php echo e(url('comment/like')); ?>",
			{ comment_id: $(this).data('id')
			}, function(data){
				if(data.success == true ){
					if( data.type == 'like' ) {
						element.html('<i class="fa fa-heart myicon-right"></i>');
						element.parent('.btn-block').find('.count').html(data.count).fadeIn();
						element.parent('.btn-block').find('.like-small').fadeIn();
						element.blur();

					} else if( data.type == 'unlike' ) {
						element.html('<i class="fa fa-heart-o myicon-right"></i>');

					if( data.count == 0 ) {
						element.parent('.btn-block').find('.count').html(data.count).fadeOut();
						element.parent('.btn-block').find('.like-small').fadeOut();
					} else {
						element.parent('.btn-block').find('.count').html(data.count).fadeIn();
						element.parent('.btn-block').find('.like-small').fadeIn();
					}

						element.blur();
					}
				} else {
					bootbox.alert(data.error);
					window.location.reload();
				}

				if( data.session_null ) {
					window.location.reload();
				}
			},'json');
		});
  <?php endif; ?>

  //<<<---------- Comments Likes
$(document).on('click','.comments-likes',function() {
   	element  = $(this);
   	var id   = element.attr("data-id");
   	var info = 'comment_id=' + id;

   		element.removeClass('comments-likes');

   		$.ajax({
   			headers: {
        	'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    		},
		   type: "POST",
		   url: "<?php echo e(url('comments/likes')); ?>",
		   data: info,
		   success: function( data ) {


                $( '#collapse'+ id ).html(data);
                $('[data-toggle="tooltip"]').tooltip();

				if( data == '' ){
					$( '#collapse'+ id ).html("<?php echo e(trans('misc.error')); ?>");
				}
				}//<-- $data
			});
   });

  <?php if( Auth::check() && Auth::user()->id == $response->user()->id ): ?>

  // Delete Photo
	 $("#deletePhoto").click(function(e) {
	   	e.preventDefault();

	   	var element = $(this);
		var url     = element.attr('data-url');

		element.blur();

		swal(
			{   title: "<?php echo e(trans('misc.delete_confirm')); ?>",
			  type: "warning",
			  showLoaderOnConfirm: true,
			  showCancelButton: true,
			  confirmButtonColor: "#DD6B55",
			   confirmButtonText: "<?php echo e(trans('misc.yes_confirm')); ?>",
			   cancelButtonText: "<?php echo e(trans('misc.cancel_confirm')); ?>",
			    closeOnConfirm: false,
			    },
			    function(isConfirm){
			    	 if (isConfirm) {
			    	 	window.location.href = url;
			    	 	}
			    	 });
			 });
	<?php endif; ?>

	//<<---- PAGINATION AJAX
        $(document).on('click','.pagination a', function(e){
			e.preventDefault();
			var page = $(this).attr('href').split('page=')[1];
			$.ajax({
				headers: {
        	'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    		},
					url: '<?php echo e(url("/")); ?>/ajax/comments?photo=<?php echo e($response->id); ?>&page=' + page


			}).done(function(data){
				if( data ) {

					scrollElement('#gridComments');

					$('.gridComments').html(data);

					jQuery(".timeAgo").timeago();

					$('[data-toggle="tooltip"]').tooltip();
				} else {
					sweetAlert("<?php echo e(trans('misc.error_oops')); ?>", "<?php echo e(trans('misc.error')); ?>", "error");
				}
				//<**** - Tooltip
			});

		});//<<---- PAGINATION AJAX

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>