<?php $__env->startSection('content'); ?>
<div class="jumbotron index-header jumbotron_set jumbotron-cover <?php if( Auth::check() ): ?> session-active-cover <?php endif; ?>">
      <div class="container wrap-jumbotron position-relative">
        <h1 class="title-site" id="titleSite"><?php echo e($settings->welcome_text); ?></h1>
        <p class="subtitle-site"><strong><?php echo e($settings->welcome_subtitle); ?></strong></p>


        	<form role="search" autocomplete="off" action="<?php echo e(url('search')); ?>" method="get">
			  <div class="input-group input-group-lg searchBar">
                    <input type="text" class="form-control" name="q" id="btnItems" placeholder="<?php echo e(trans('misc.title_search_bar')); ?>">
                    <span class="input-group-btn">
                      <button class="btn btn-main btn-flat" type="submit" id="btnSearch">
                      	<i class="glyphicon glyphicon-search"></i>
                      </button>
                    </span>
                  </div>
                  </form>
      </div><!-- container wrap-jumbotron -->
</div><!-- jumbotron -->


	<div class="container margin-bottom-40">

		<div class="row margin-bottom-20">

		<?php if( $images->total() != 0 ): ?>
			<div class="col-md-12 btn-block margin-bottom-40">
				<h1 class="btn-block text-center class-montserrat margin-bottom-zero none-overflow highlight-word-color"><?php echo e(trans('misc.recent')); ?> <span class="color-default"><?php echo e(Lang::choice('misc.images_plural',0)); ?></span></h1>
				<h5 class="btn-block text-center class-montserrat text-uppercase"><?php echo e(trans('misc.title_2_index')); ?></h5>
			</div>


	<div id="imagesFlex" class="flex-images btn-block margin-bottom-40">
	     <?php echo $__env->make('includes.images', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	  </div><!-- Image Flex -->

	  <div class="col-md-12 text-center margin-bottom-20">
                  	<a href="<?php echo e(url('latest')); ?>" class="btn btn-lg btn-main custom-rounded">
                  		<?php echo e(trans('misc.view_all')); ?> <i class="fa fa-long-arrow-right"></i>
                  		</a>
                  </div>

	  <?php else: ?>
	  <div class="btn-block text-center">
	    			<i class="icon icon-Picture ico-no-result"></i>
	    		</div>

	    		<h3 class="margin-top-none text-center no-result no-result-mg">
	    		<?php echo e(trans('misc.no_images_published')); ?>

	    	</h3>
	  <?php endif; ?>

		</div><!-- row -->

		<div class="row margin-bottom-40">

		<div class="container">
			<div class="col-md-4 border-stats">
					<h1 class="btn-block text-center class-montserrat margin-bottom-zero none-overflow"><span class=".numbers-with-commas counter"><?php echo html_entity_decode( App\Helper::formatNumbersStats(  App\Models\User::where('status','active')->count() ) ) ?></span></h1>
					<h5 class="btn-block text-center class-montserrat subtitle-color text-uppercase"><?php echo e(trans('misc.members')); ?></h5>
				</div><!-- col-md-3 -->

			<div class="col-md-4 border-stats">
					<h1 class="btn-block text-center class-montserrat margin-bottom-zero none-overflow"><span class=".numbers-with-commas counter"><?php echo html_entity_decode( App\Helper::formatNumbersStats( App\Models\Downloads::count() ) ) ?></span></h1>
					<h5 class="btn-block text-center class-montserrat subtitle-color text-uppercase"><?php echo e(trans('misc.downloads')); ?></h5>
				</div><!-- col-md-3 -->

				<div class="col-md-4 border-stats">
					<h1 class="btn-block text-center class-montserrat margin-bottom-zero none-overflow"><span class=".numbers-with-commas counter"><?php echo html_entity_decode( App\Helper::formatNumbersStats( App\Models\Images::where('status','active')->count() ) ) ?></span></h1>
					<h5 class="btn-block text-center class-montserrat subtitle-color text-uppercase"><?php echo e(trans('misc.stock_photos')); ?></h5>
				</div><!-- col-md-3 -->

	<?php if( isset( $settings->google_adsense ) && $settings->google_ads_index == 'on' && $settings->google_adsense_index != '' ): ?>
		<div class="col-md-12 margin-top-40">
		<?php echo html_entity_decode($settings->google_adsense_index); ?>
		</div>
		<?php endif; ?>

		</div><!-- row -->
		</div>

	</div><!-- container wrap-ui -->




	<div class="jumbotron jumbotron-bottom margin-bottom-zero jumbotron-cover">
      <div class="container wrap-jumbotron position-relative">
        <h1 class="title-site"><?php echo e(trans('misc.title_2_index')); ?></h1>
        <p class="subtitle-site"><strong><?php echo e($settings->welcome_subtitle); ?></strong></p>


        <?php if( Auth::check() || $settings->registration_active == 0	 ): ?>
        	<form role="search" autocomplete="off" action="<?php echo e(url('search')); ?>" method="get">
			  <div class="input-group input-group-lg searchBar">
                    <input type="text" class="form-control" name="q" id="btnItems_2" placeholder="<?php echo e(trans('misc.title_search_bar')); ?>">
                    <span class="input-group-btn">
                      <button class="btn btn-main btn-flat" type="submit" id="btnSearch_2">
                      	<i class="glyphicon glyphicon-search"></i>
                      </button>
                    </span>
                  </div>
                  </form>

                  <?php else: ?>
                  <div class="btn-block text-center">
                  	<a href="<?php echo e(url('register')); ?>" class="btn btn-lg btn-main custom-rounded">
                  		<?php echo e(trans('misc.signup_free')); ?>

                  		</a>
                  </div>

                  <?php endif; ?>


      </div><!-- container wrap-jumbotron -->
</div><!-- jumbotron -->

<div class="wrapper">
<div class="container">
	<div class="row margin-bottom-40">
				<div class="col-md-12 btn-block margin-bottom-40">
					<h1 class="btn-block text-center class-montserrat margin-bottom-zero none-overflow color-white"><?php echo e(trans('misc.categories')); ?></h1>
					<h5 class="btn-block text-center class-montserrat text-uppercase color-gray"><?php echo e(trans('misc.browse_by_category')); ?></h5>
				</div>

	    	<?php $__currentLoopData = $categories->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>

	    		<div class="col-md-3 col-center">
	    			<ul class="list-unstyled imagesCategory">
	    		<?php $__currentLoopData = $column; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>

	        				<li>
	        					<a class="link-category" href="<?php echo e(url('category')); ?>/<?php echo e($category->slug); ?>"><?php echo e($category->name); ?> (<?php echo e($category->images()->count()); ?>) </a>
	        					</li>

	        			<?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

	        				</ul>
	        			</div>
	        	<?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

	        	<?php if( $categories->total() > 11 ): ?>
	        		<div class="col-md-12 text-center margin-top-40">
                  	<a href="<?php echo e(url('categories')); ?>" class="btn btn-lg btn-main custom-rounded">
                  		<?php echo e(trans('misc.view_all')); ?> <i class="fa fa-long-arrow-right"></i>
                  		</a>
                  </div>
	        	<?php endif; ?>

			</div><!-- row -->
	</div><!-- container -->
</div><!-- wrapper -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
	<script src="<?php echo e(asset('public/plugins/jquery.counterup/jquery.counterup.min.js')); ?>"></script>
	<script src="<?php echo e(asset('public/plugins/jquery.counterup/waypoints.min.js')); ?>"></script>

		<script type="text/javascript">

		 $('#imagesFlex').flexImages({ rowHeight: 220, maxRows: 8, truncate: true });


		jQuery(document).ready(function( $ ) {
			$('.counter').counterUp({
			delay: 10, // the delay time in ms
			time: 1000 // the speed time in ms
			});
		});

		 <?php if(session('success_verify')): ?>
    		swal({
    			title: "<?php echo e(trans('misc.welcome')); ?>",
    			text: "<?php echo e(trans('users.account_validated')); ?>",
    			type: "success",
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>"
    			});
   		 <?php endif; ?>

   		 <?php if(session('error_verify')): ?>
    		swal({
    			title: "<?php echo e(trans('misc.error_oops')); ?>",
    			text: "<?php echo e(trans('users.code_not_valid')); ?>",
    			type: "error",
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>"
    			});
   		 <?php endif; ?>

		</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>