<?php
// ** Data User logged ** //
$user = Auth::user();
	  ?>


<?php $__env->startSection('title'); ?> <?php echo e(trans('users.notifications')); ?> - <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?> 
<div class="jumbotron md index-header jumbotron_set jumbotron-cover">
	<div class="container wrap-jumbotron position-relative">
		<h1 class="title-site title-sm"><?php echo e(trans('users.notifications')); ?></h1>
		
		<?php if( $sql->count() !=  0  ): ?>
		<p class="subtitle-site delete-notifications">
			<strong><i class="fa fa-trash myicon-right"></i> <?php echo e(trans('users.delete_all_notifications')); ?></strong>
		</p>
		<?php endif; ?>
		
	</div>
</div>

<div class="container margin-bottom-40">

	<!-- Col MD -->
	<div class="col-md-12">
		<div class="wrap-center center-block">

			<dl class="margin-zero">

				<?php

 if( $sql->count() !=  0 ) {

	  foreach ( $sql as $key ) {
	  	
		$url_photo = url('photo').'/'.$key->id;
						
		switch( $key->type ) {
			case 1:
				$action          = trans('users.followed_you');
				$icoDefault      = '<i class="icon icon-User ico-btn-followed"></i>';
				$title           = null;
				$linkDestination = false;
				break;
			case 2:
				$action          = trans('users.like_you_photo');
				$icoDefault      = '<i class="icon-heart ico-btn-like"></i>';
				$title           = $key->title;
				$linkDestination = $url_photo;
				break;
			case 3:
				$action          = trans('users.comment_you_photo');
				$icoDefault      = '<i class="icon-bubble"></i>';
				$title           = $key->title;
				$linkDestination = $url_photo;
				break;
				
			case 4:
				$action          = trans('users.liked_your_comment');
				$icoDefault      = '<i class="icon-heart ico-btn-like"></i>';
				$title           = $key->title;
				$linkDestination = $url_photo;
				break;
		}

?>
				<!-- Start -->
				<div class="media li-group noty-media">
					<div class="pull-left">
						<a href="<?php echo e(url('/')); ?>/<?php echo e($key->username); ?>"> <img width="40" height="40" class="img-circle myicon-righ media-objectt" alt="User" src="<?php echo e(asset('public/avatar').'/'.$key->avatar); ?>"> </a>
					</div>
					<div class="media-body">
						<div class="pull-right small">
							<span class="timestamp timeAgo" data="<?php echo e(date('c', strtotime( $key->created_at ))); ?>"></span>
						</div>
						<h5 class="media-heading"><a href="<?php echo e(url('/')); ?>/<?php echo e($key->username); ?>"> <strong><?php echo e(e( $key->username )); ?></strong> </a></h5>

						<p class="list-grid-block p-text" style="height: auto; padding: 0 2px;">
							<?php echo $icoDefault; ?> <?php echo e($action); ?>


							<?php if( $linkDestination != false ): ?>
							<a href="<?php echo e($linkDestination); ?>"> <strong><?php echo e(e(str_limit($title, 30,  '...'))); ?></strong> </a>
							<?php endif; ?>

						</p>
					</div>
				</div>
				<!-- End -->

				<?php
				}//foreach

				} // != 0
 ?>

				<?php if( $sql->count() == 0 ): ?>

				<div class="btn-block text-center">
					<i class="icon icon-Ringer ico-no-result"></i>
				</div>

				<h3 class="margin-top-none text-center no-result color-no-result"> <?php echo e(Lang::get('misc.no_notifications')); ?> </h3>

				<?php endif; ?>

			</dl>

			<?php if( $sql->lastPage() > 1 ): ?>

			<hr />
			<?php echo e($sql->links()); ?>


			<?php endif; ?>

		</div><!-- wrap center -->
	</div><!-- /COL MD -->

</div><!-- container -->

<!-- container wrap-ui -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

<script type="text/javascript">
	//<<<---------- Delete Account
	$(".delete-notifications").click(function(e) {
		e.preventDefault();

		var element = $(this);
		var url = '<?php echo e(url("notifications/delete")); ?>';

		swal({
			title : "<?php echo e(trans('misc.delete_confirm')); ?>",
			text : "<?php echo e(trans('misc.confirm_delete_all_notifications')); ?>",
			type : "warning",
			showLoaderOnConfirm : true,
			showCancelButton : true,
			confirmButtonColor : "#DD6B55",
			confirmButtonText : "<?php echo e(trans('misc.yes_confirm')); ?>",
			cancelButtonText : "<?php echo e(trans('misc.cancel_confirm')); ?>",
			closeOnConfirm : false, 
		}, function(isConfirm) {
			if (isConfirm) {
				window.location.href = url;
			}
		});

	}); 
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>