<?php 
	$trueProfile = true;
	
	$userID = $user->id;
	
	$downloadsCount = App\Models\Images::join('downloads', function($join) use($userID) {
				$join->on('downloads.images_id', '=', 'images.id')->where('images.user_id', '=', $userID );
			})->count();	
			
			if( $user->cover == '' ) {
				$cover = 'background: #232a29;';
			}	else {
				$cover = "background: url('public/cover/$user->cover') no-repeat center center #232a29; background-size: cover;";
			}
			
if( Auth::check() ) {
	
	// FOLLOW ACTIVE
 	$followActive = App\Models\Followers::where( 'follower', Auth::user()->id )
 	->where('following',$user->id)
	->where('status', '1')
 	->first(); 
			 
       if( $followActive ) {
       	  $textFollow   = trans('users.following');
		  $icoFollow    = '-ok';
		  $activeFollow = 'btnFollowActive';
       } else {
       		$textFollow   = trans('users.follow');
		    $icoFollow    = '-plus';
			$activeFollow = '';
       }
	   	   
 }//<<<<---- *** END AUTH ***
?>



<?php $__env->startSection('title'); ?> <?php echo e($title); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="jumbotron profileUser index-header jumbotron_set jumbotron-cover-user" style="<?php echo e($cover); ?>">

<div class="container wrap-jumbotron position-relative">	

<?php if( Auth::check() && Auth::user()->id == $user->id ): ?>	
	<!-- *********** COVER ************* -->  
      <form class="pull-left myicon-right position-relative" style="z-index: 100;" action="<?php echo e(url('upload/cover')); ?>" method="POST" id="formCover" accept-charset="UTF-8" enctype="multipart/form-data">
    		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
			<button type="button" class="btn btn-default btn-border btn-sm" id="cover_file" style="margin-top: 10px;">
	    		<i class="icon-camera myicon-right"></i> <?php echo e(trans('misc.change_cover')); ?>

	    		</button>
	    		 <input type="file" name="photo" id="uploadCover" accept="image/*" style="visibility: hidden;">
			</form><!-- *********** COVER ************* -->

			<?php endif; ?>
			</div>
    </div>

<div class="container margin-bottom-40 margin-top-40">
	
	<div class="row"></div>
<!-- Col MD -->
<div class="col-md-12">	

	<div class="center-block text-center profile-user-over">
		
		<a href="<?php echo e(url($user->username)); ?>">
        		<img src="<?php echo e(asset('public/avatar').'/'.$user->avatar); ?>" width="125" height="125" class="img-circle border-avatar-profile avatarUser" />
        		</a> 
        		
        <h1 class="title-item none-overflow font-default">
		        		<?php if( $user->name != '' ): ?>
		        		
		        		<?php echo e(e( $user->name )); ?> <small class="text-muted"><?php echo e('@'.$user->username); ?></small>
		        		
		        		<?php else: ?>
		        		
		        		<?php echo e(e( $user->username )); ?>

		        		
		        		<?php endif; ?>
		        	</h1>
        
        
<?php if( Auth::check() && Auth::user()->id == $user->id ): ?>
	<!-- *********** AVATAR ************* -->  
      <form action="<?php echo e(url('upload/avatar')); ?>" method="POST" id="formAvatar" accept-charset="UTF-8" enctype="multipart/form-data">
    		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
			<button type="button" class="btn btn-default btn-border btn-sm" id="avatar_file" style="margin-top: 10px;">
	    		<i class="icon-camera myicon-right"></i> <?php echo e(trans('misc.change_avatar')); ?>

	    		</button>
	    		 <input type="file" name="photo" id="uploadAvatar" accept="image/*" style="visibility: hidden;">
			</form><!-- *********** AVATAR ************* -->
			<?php endif; ?>
			
			<?php if( Auth::check() && $user->id != Auth::user()->id ): ?>	
						<button type="button" class="btn btn-xs add-button btn-follow myicon-right btnFollow <?php echo e($activeFollow); ?>" data-toggle="tooltip" data-placement="top" data-id="<?php echo e($user->id); ?>" data-follow="<?php echo e(trans('users.follow')); ?>" data-following="<?php echo e(trans('users.following')); ?>">
	    			 			<i class="glyphicon glyphicon<?php echo e($icoFollow); ?> myicon-right"></i> <?php echo e($textFollow); ?>

	    			 		</button>
	    			 	<?php endif; ?>
	    			
	    			<?php if( Auth::check() && $user->id != Auth::user()->id && $user->paypal_account != '' || Auth::guest()  && $user->paypal_account != '' ): ?> 	
	    			 	<button type="button" class="btn btn-sm btn-default" id="btnFormPP" title="<?php echo e(trans('misc.buy_coffee')); ?>">
	    			 			<i class="fa fa-paypal myicon-right" style="color: #003087"></i> <?php echo e(trans('misc.coffee')); ?>

	    			 		</button>
	    			 		<?php endif; ?>
	    			 	
	    			 	<?php if( Auth::check() && $user->id != Auth::user()->id ): ?>	
	    			 		<a href="#" class="btn btn-sm btn-default" data-toggle="modal" data-target="#reportUser" title="<?php echo e(trans('misc.report')); ?>">
	    			 			<i class="fa fa-flag"></i>
	    			 		</a>
	    			 		<?php endif; ?>
    			    				
		<h4 class="text-bold line-sm position-relative font-family-primary font-default text-muted"><?php echo e(trans('users.about_me')); ?></h4>
    						   
		   	 <small class="center-block subtitle-user">
      		 	<?php echo e(trans('misc.member_since')); ?> <?php echo e(date('M d, Y', strtotime($user->date) )); ?>

      		 	</small>
      		 	
      		 <?php if( $user->countries_id != '' ): ?>	
      		 	<small class="center-block subtitle-user">
      		 		<i class="fa fa-map-marker myicon-right"></i> <?php echo e($user->country()->country_name); ?>

      		 	</small>
      		 	<?php endif; ?>
                   
           <?php if( $user->bio != '' ): ?>
           <h4 class="text-center bio-user none-overflow"><?php echo e(e($user->bio)); ?></h4>
           <?php endif; ?>
           
           <?php if( $user->website != '' 
			            	 || $user->twitter != ''
			            	 || $user->facebook != ''
			             ): ?>
			             
			             <?php if( $user->website != '' ): ?>
    							<a target="_blank" href="<?php echo e(e( $user->website )); ?>" title="<?php echo e(trans('misc.website_misc')); ?>" class="urls-bio icons-bio" data-toggle="tooltip" data-placement="top">
    								<i class="icon-link myicon-right"></i>
    							</a> 
    							<?php endif; ?>
    						
    						<?php if( $user->twitter != '' ): ?>	
    							<a target="_blank" href="<?php echo e(e($user->twitter)); ?>" title="Twitter"  class="urls-bio icons-bio" data-toggle="tooltip" data-placement="top">
    								<i class="icon-twitter myicon-right"></i>
    								</a>
    							<?php endif; ?>
    							
    							<?php if( $user->facebook != '' ): ?>	
    							<a target="_blank" href="<?php echo e(e($user->facebook)); ?>" title="Facebook"  class="urls-bio icons-bio" data-toggle="tooltip" data-placement="top">
    								<i class="fa fa-facebook-square myicon-right"></i>
    								</a>
    							<?php endif; ?>
    							
    							<?php if( $user->google != '' ): ?>	
    							<a target="_blank" href="<?php echo e(e($user->google)); ?>" title="Google +"  class="urls-bio icons-bio" data-toggle="tooltip" data-placement="top">
    								<i class="fa fa-google-plus myicon-right"></i>
    								</a>
    							<?php endif; ?>
    							
			             <?php endif; ?>
			             
	   <ul class="nav nav-pills inlineCounterProfile">
        	  
        	  <li>
        	  	<small class="btn-block sm-btn-size text-left counter-sm"><?php echo e(App\Helper::formatNumber($user->images()->count())); ?></small>
        	  	<span class="text-muted"><?php echo e(trans('misc.images')); ?></span>
        	  </li><!-- End Li -->
        	 
        	 <?php if( Auth::check() && Auth::user()->id == $user->id ): ?> 
        	  <li>
        	  	<small class="btn-block sm-btn-size text-left counter-sm"><?php echo e(App\Helper::formatNumber($user->images_pending()->count())); ?></small>
        	  	<a href="<?php echo e(url( 'photos/pending')); ?>" class="text-muted link-nav-user"><?php echo e(trans('misc.photos_pending')); ?></a>
        	  </li><!-- End Li -->
        	  <?php endif; ?>
        	  
        	  <li>
        	  	<small class="btn-block sm-btn-size text-left counter-sm"><?php echo e(App\Helper::formatNumber($downloadsCount)); ?></small>
        	  	<span class="text-muted"><?php echo e(trans('misc.downloads')); ?></span>
        	  </li><!-- End Li -->
        	  	
    			<li>
    				<small class="btn-block sm-btn-size text-left counter-sm"><?php echo e(App\Helper::formatNumber($user->followers()->count())); ?></small>
    				<a href="<?php echo e(url($user->username, 'followers')); ?>" class="text-muted link-nav-user"><?php echo e(trans('users.followers')); ?></a>
    			</li><!-- End Li -->
    			
    			<li>
    				<small class="btn-block sm-btn-size text-left counter-sm"><?php echo e(App\Helper::formatNumber($user->following()->count())); ?></small>
    				<a href="<?php echo e(url( $user->username, 'following')); ?>" class="text-muted link-nav-user"><?php echo e(trans('users.following')); ?></a>
    			</li><!-- End Li -->
    			
    			<li>
    				<small class="btn-block sm-btn-size text-left counter-sm"><?php echo e(App\Helper::formatNumber($user->collections()->count())); ?></small>
    				<a href="<?php echo e(url( $user->username, 'collections')); ?>" class="text-muted link-nav-user"><?php echo e(trans('misc.collections')); ?></a>
    			</li><!-- End Li -->
    	</ul>
           
	</div><!-- Center Div -->

<hr />

	<?php if( $images->total() != 0 ): ?>	

<div id="imagesFlex" class="flex-images btn-block margin-bottom-40 dataResult">
	     <?php echo $__env->make('includes.images', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	     
	     <?php if( $images->count() != 0  ): ?>   
			    <div class="container-paginator">
			    	<?php echo e($images->links()); ?>

			    	</div>	
			    	<?php endif; ?>
	     
	     </div><!-- Image Flex -->
	     			    		 
	  <?php else: ?>
	  <div class="btn-block text-center">
	    			<i class="icon icon-Picture ico-no-result"></i>
	    		</div>
	    		
	    		<h3 class="margin-top-none text-center no-result no-result-mg">
	    		<?php echo e(trans('users.user_no_images')); ?>

	    	</h3>
	  <?php endif; ?>

 </div><!-- /COL MD -->
 </div><!-- row -->

<?php if( Auth::check() && $user->id != Auth::user()->id && $user->paypal_account != '' || Auth::guest()  && $user->paypal_account != '' ): ?> 
 <form id="form_pp" name="_xclick" action="https://www.paypal.com/cgi-bin/webscr" method="post"  style="display:none">
    <input type="hidden" name="cmd" value="_donations">
    <input type="hidden" name="return" value="<?php echo e(url($user->username)); ?>">
    <input type="hidden" name="cancel_return"   value="<?php echo e(url($user->username)); ?>">
    <input type="hidden" name="currency_code" value="USD">
    <input type="hidden" name="item_name" value="<?php echo e(trans('misc.support').' @'.$user->username); ?> - <?php echo e($settings->title); ?>" >
    <input type="hidden" name="business" value="<?php echo e($user->paypal_account); ?>">
    <input type="submit">
</form>
<?php endif; ?>

<?php if( Auth::check() ): ?>
<div class="modal fade" id="reportUser" tabindex="-1" role="dialog" aria-hidden="true">
     		<div class="modal-dialog modal-sm">
     			<div class="modal-content"> 
     				<div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
				        <h4 class="modal-title text-center" id="myModalLabel">
				        	<strong><?php echo e(trans('misc.report')); ?></strong>
				        	</h4>
				     </div><!-- Modal header -->
				     
				      <div class="modal-body listWrap">
				    
				    <!-- form start -->
			    <form method="POST" action="<?php echo e(url('report/user')); ?>" enctype="multipart/form-data" id="formReport">
			    	<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
			    	<input type="hidden" name="id" value="<?php echo e($user->id); ?>">  	
				    <!-- Start Form Group -->
                    <div class="form-group">
                      <label><?php echo e(trans('admin.reason')); ?></label>
                      	<select name="reason" class="form-control">
                      		<option value="spoofing"><?php echo e(trans('admin.spoofing')); ?></option>
                            <option value="copyright"><?php echo e(trans('admin.copyright')); ?></option>
                            <option value="privacy_issue"><?php echo e(trans('admin.privacy_issue')); ?></option>
                            <option value="violent_sexual_content"><?php echo e(trans('admin.violent_sexual_content')); ?></option>
                          </select>
                               
                  </div><!-- /.form-group-->
                  
                   <button type="submit" class="btn btn-sm btn-danger reportUser"><?php echo e(trans('misc.report')); ?></button>
                   
                    </form>

				      </div><!-- Modal body -->
     				</div><!-- Modal content -->
     			</div><!-- Modal dialog -->
     		</div><!-- Modal -->
     		<?php endif; ?>
 
 <!-- container wrap-ui -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

<script type="text/javascript">
        		
$('#imagesFlex').flexImages({ rowHeight: 220 });

$('#btnFormPP').click(function(e){
	$('#form_pp').submit();
});

<?php if( Auth::check() ): ?>

$(".reportUser").click(function(e) {
  	var element     = $(this);
	e.preventDefault();
  	 element.attr({'disabled' : 'true'});
  	 
  	 $('#formReport').submit();
  	 
  });
  
	<?php if(session('noty_error')): ?>
	    		swal({   
	    			title: "<?php echo e(trans('misc.error_oops')); ?>",   
	    			text: "<?php echo e(trans('misc.already_sent_report')); ?>",   
	    			type: "error",   
	    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>" 
	    			});
	   		 <?php endif; ?>
	   		 
	   		 <?php if(session('noty_success')): ?>
	    		swal({   
	    			title: "<?php echo e(trans('misc.thanks')); ?>",   
	    			text: "<?php echo e(trans('misc.send_success')); ?>",   
	    			type: "success",   
	    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>" 
	    			});
	   		 <?php endif; ?>
  <?php endif; ?>
   		 

//<<---- PAGINATION AJAX
        $(document).on('click','.pagination a', function(e){
			e.preventDefault();
			var page = $(this).attr('href').split('page=')[1];
			$.ajax({
				headers: {
        	'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    		},
					url: '<?php echo e(url("/")); ?>/ajax/user/images?id=<?php echo e($user->id); ?>&page=' + page
					
				
			}).done(function(data){
				if( data ) {
					
					scrollElement('#imagesFlex');
					
					$('.dataResult').html(data);
					
					$('.hovercard').hover(
		               function () {
		                  $(this).find('.hover-content').fadeIn();
		               }, 
		               function () {
		                  $(this).find('.hover-content').fadeOut();
		               }
		            );
            
					$('#imagesFlex').flexImages({ rowHeight: 220 });
					jQuery(".timeAgo").timeago();
					
					$('[data-toggle="tooltip"]').tooltip();
				} else {
					sweetAlert("<?php echo e(trans('misc.error_oops')); ?>", "<?php echo e(trans('misc.error')); ?>", "error");
				}
				//<**** - Tooltip
			});
			
		});//<<---- PAGINATION AJAX
		 
<?php if( Auth::check() && Auth::user()->id == $user->id ): ?>

	//<<<<<<<=================== * UPLOAD AVATAR  * ===============>>>>>>>//
    $(document).on('change', '#uploadAvatar', function(){
    
    $('.wrap-loader').show();
    
   (function(){
	 $("#formAvatar").ajaxForm({
	 dataType : 'json',	
	 success:  function(e){
	 if( e ){
        if( e.success == false ){
		$('.wrap-loader').hide();
		
		var error = '';
                        for($key in e.errors){
                        	error += '' + e.errors[$key] + '';
                        }
		swal({   
    			title: "<?php echo e(trans('misc.error_oops')); ?>",   
    			text: ""+ error +"",   
    			type: "error",   
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>" 
    			});
		
			$('#uploadAvatar').val('');

		} else {
			
			$('#uploadAvatar').val('');
			$('.avatarUser').attr('src',e.avatar);
			$('.wrap-loader').hide();
		}
		
		}//<-- e
			else {
				$('.wrap-loader').hide();
				swal({   
    			title: "<?php echo e(trans('misc.error_oops')); ?>",   
    			text: '<?php echo e(trans("misc.error")); ?>',   
    			type: "error",   
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>" 
    			});
    			
				$('#uploadAvatar').val('');
			}
		   }//<----- SUCCESS
		}).submit();
    })(); //<--- FUNCTION %
});//<<<<<<<--- * ON * --->>>>>>>>>>>
//<<<<<<<=================== * UPLOAD AVATAR  * ===============>>>>>>>//

//<<<<<<<=================== * UPLOAD COVER  * ===============>>>>>>>//
$(document).on('change', '#uploadCover', function(){
    
    $('.wrap-loader').show();
    
   (function(){
	 $("#formCover").ajaxForm({
	 dataType : 'json',	
	 success:  function(e){
	 if( e ){
        if( e.success == false ){
		$('.wrap-loader').hide();
		
		var error = '';
                        for($key in e.errors){
                        	error += '' + e.errors[$key] + '';
                        }
		swal({   
    			title: "<?php echo e(trans('misc.error_oops')); ?>",   
    			text: ""+ error +"",   
    			type: "error",   
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>" 
    			});
		
			$('#uploadCover').val('');

		} else {
			
			$('#uploadCover').val('');
			
			$('.jumbotron-cover-user').css({ background: 'url("'+e.cover+'") center center #232a29','background-size': 'cover' });;
			$('.wrap-loader').hide();
		}
		
		}//<-- e
			else {
				$('.wrap-loader').hide();
				swal({   
    			title: "<?php echo e(trans('misc.error_oops')); ?>",   
    			text: '<?php echo e(trans("misc.error")); ?>',   
    			type: "error",   
    			confirmButtonText: "<?php echo e(trans('users.ok')); ?>" 
    			});
    			
				$('#uploadCover').val('');
			}
		   }//<----- SUCCESS
		}).submit();
    })(); //<--- FUNCTION %
});//<<<<<<<--- * ON * --->>>>>>>>>>>
//<<<<<<<=================== * UPLOAD COVER  * ===============>>>>>>>//

<?php endif; ?>
</script>
 	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>