<?php 
if( Auth::check() ) {
 	$followActive = $user->followers()->where( 'follower', Auth::user()->id )->first(); 
			 
       if( $followActive ) {
       	  $textFollow   = trans('users.following');
		  $icoFollow    = '-ok';
		  $activeFollow = 'btnFollowActive';
       } else {
       		$textFollow   = trans('users.follow');
		    $icoFollow    = '-plus';
			$activeFollow = '';
       }
	   
 }//<<<<---- Auth
 ?>
 <article class="container-user">
			
			<div class="media">
			  <div class="media-left">
			    <a href="<?php echo e(url($user->username)); ?>">
			      <img src="<?php echo e(url('public/avatar/',$user->avatar)); ?>" class="img-circle avatar-user">
			    </a>
			  </div>
			  <div class="media-body text-overflow">
			    <h4 class="media-heading data-user"><a href="<?php echo e(url($user->username)); ?>"><?php echo e($user->username); ?></a></h4>
			    <ul class="padding-zero list-data-user">
						
						
						<li><i class="fa fa-clock-o myicon-right" aria-hidden="true"></i> <?php echo e(trans('misc.member_since')); ?> <?php echo e(App\Helper::formatDate($user->date)); ?></li>
						
						<?php if( $user->countries_id != '' ): ?>
						<li><i class="fa fa-map-marker myicon-right" aria-hidden="true"></i> <?php echo e($user->country()->country_name); ?></li>
						<?php endif; ?>
						
						<?php if( $user->website != '' ): ?>
						<li><i class="fa fa-link myicon-right"></i> <a href="<?php echo e($user->website); ?>" target="_blank"><?php echo e($user->website); ?></a> </li>
						<?php endif; ?>
					
					<?php if( Auth::check() && $user->id != Auth::user()->id ): ?>	
						<button type="button" class="btn btn-xs add-button btn-follow myicon-right btnFollow <?php echo e($activeFollow); ?>" data-toggle="tooltip" data-placement="top" data-id="<?php echo e($user->id); ?>" data-follow="<?php echo e(trans('users.follow')); ?>" data-following="<?php echo e(trans('users.following')); ?>">
	    			 			<i class="glyphicon glyphicon<?php echo e($icoFollow); ?> myicon-right"></i> <?php echo e($textFollow); ?>

	    			 		</button>
	    			 	<?php endif; ?>
						
					</ul>
			  </div>
			
			  <div class="media-right m-right text-center data-stats">
			  	<div class="btn-block color-default count-data"><?php echo e(App\Helper::formatNumber( $user->followers()->count() )); ?></div>
				<div class="btn-block color-link data-refer"><?php echo e(trans('users.followers')); ?></div>
			  </div>
			  
			  <div class="media-right m-right text-center data-stats">
			  		<div class="btn-block color-default count-data"><?php echo e(App\Helper::formatNumber( $user->images()->count() )); ?></div>
					<div class="btn-block color-link data-refer"><?php echo e(trans_choice('misc.photos_plural', $user->images()->count() )); ?></div>
				</div>
								
			</div>
			
		</article>
