<?php $__env->startSection('content'); ?>
<!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h4>
           <?php echo e(trans('admin.admin')); ?> <i class="fa fa-angle-right margin-separator"></i> <?php echo e(trans('admin.images_reported')); ?> (<?php echo e($data->count()); ?>)
          </h4>
     
        </section>

        <!-- Main content -->
        <section class="content">
        	       	
		    <?php if(Session::has('success_message')): ?>
		    <div class="alert alert-success">
		    	<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">×</span>
								</button>
		       <i class="fa fa-check margin-separator"></i> <?php echo e(Session::get('success_message')); ?>	        
		    </div>
		<?php endif; ?>
		    
        	<div class="row">
            <div class="col-xs-12">
              <div class="box">

                <div class="box-body table-responsive no-padding">
                  <table class="table table-hover">
               <tbody>

               	<?php if( $data->count() !=  0 ): ?>
                   <tr>
                      <th class="active">ID</th>
                      <th class="active"><?php echo e(trans('admin.report_by')); ?></th>
                      <th class="active"><?php echo e(trans('admin.reported')); ?></th>
                      <th class="active"><?php echo e(trans('admin.reason')); ?></th>
                      <th class="active"><?php echo e(trans('admin.date')); ?></th>
                      <th class="active"><?php echo e(trans('admin.actions')); ?></th>
                    </tr>
                  
                  <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                    <tr>
                      <td><?php echo e($report->id); ?></td>
                      <td><a href="<?php echo e(url($report->user()->username)); ?>" target="_blank"><?php echo e($report->user()->username); ?> <i class="fa fa-external-link-square"></i></a></td>
                      <td><a href="<?php echo e(url('photo', $report->image()->id)); ?>" target="_blank"><?php echo e(str_limit($report->image()->title, 10, '...')); ?> <i class="fa fa-external-link-square"></i></a></td>
                      
                      <?php if( $report->reason == 'copyright' ) {
								$reason = trans('admin.copyright');
                      		} elseif( $report->reason == 'privacy_issue' ) {
								$reason = trans('admin.privacy_issue');
                      		} else if( $report->reason == 'violent_sexual_content' ) {
								$reason = trans('admin.violent_sexual_content');
                      		}
                      		
                      	?>
                      		
                      <td><?php echo e($reason); ?></td>
                      
                      <td><?php echo e(App\Helper::formatDate($report->created_at)); ?></td>
                      <td>
                      	
                      	
                 <?php echo Form::open([
			            'method' => 'POST',
			            'url' => 'panel/admin/images-reported',
			            'class' => 'displayInline'
				        ]); ?>

				     <?php echo Form::hidden('id',$report->id );; ?>

	        <?php echo Form::submit(trans('admin.delete_report'), ['class' => 'btn btn-danger btn-xs padding-btn actionDelete']); ?>

	        
	        	<?php echo Form::close(); ?>

                      		
                      		</td>
                      
                    </tr><!-- /.TR -->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                    
                    <?php else: ?>
                    	<h3 class="text-center no-found"><?php echo e(trans('misc.no_results_found')); ?></h3>
                    <?php endif; ?>
                                        
                  </tbody>
                  
                  
                  </table>
                </div><!-- /.box-body -->
              </div><!-- /.box -->
            </div>
          </div>        	
        	
          <!-- Your Page Content Here -->

        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
	
<script type="text/javascript">

$(".actionDelete").click(function(e) {
   	e.preventDefault();
   	   	
   	var element = $(this);
	var url     = element.attr('href');
	var form    = $(element).parents('form');
	
	element.blur();
	
	swal(
		{   title: "<?php echo e(trans('misc.delete_confirm')); ?>",  
		  type: "warning", 
		  showLoaderOnConfirm: true,
		  showCancelButton: true,   
		  confirmButtonColor: "#DD6B55",  
		   confirmButtonText: "<?php echo e(trans('misc.yes_confirm')); ?>",   
		   cancelButtonText: "<?php echo e(trans('misc.cancel_confirm')); ?>",  
		    closeOnConfirm: false, 
		    }, 
		    function(isConfirm){  
		    	 if (isConfirm) {   
		    	 	form.submit(); 
		    	 	}
		    	 });
		    	 
		    	 
		 });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>