

<?php $__env->startSection('content'); ?>
<!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h4>
           <?php echo e(trans('admin.admin')); ?> <i class="fa fa-angle-right margin-separator"></i> <?php echo e(trans_choice('misc.images_plural', 0)); ?> (<?php echo e($data->total()); ?>)
          </h4>
     
        </section>

        <!-- Main content -->
        <section class="content">
        	 
        	 <?php if(Session::has('info_message')): ?>
		    <div class="alert alert-warning">
		    	<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">×</span>
								</button>
		      <i class="fa fa-warning margin-separator"></i>  <?php echo e(Session::get('info_message')); ?>	        
		    </div>
		<?php endif; ?>
		      	
		    <?php if(Session::has('success_message')): ?>
		    <div class="alert alert-success">
		    	<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">×</span>
								</button>
		       <i class="fa fa-check margin-separator"></i>  <?php echo e(Session::get('success_message')); ?>	        
		    </div>
		<?php endif; ?>
		    
        	<div class="row">
            <div class="col-xs-12">
              <div class="box">
                <div class="box-header">
               <?php if( $data->total() !=  0 && $data->count() != 0 ): ?>   
               
               <form action="<?php echo e(url('panel/admin/images')); ?>" id="formSort" method="get">
                  <select name="sort" id="sort" class="form-control input-sm" style="width: auto; padding-right: 20px;">
	                    <option <?php if( $sort == ''): ?> selected="selected" <?php endif; ?> value=""><?php echo e(trans('admin.sort_id')); ?></option>
	                    <option <?php if( $sort == 'pending'): ?> selected="selected" <?php endif; ?> value="pending"><?php echo e(trans('admin.pending')); ?></option>
					  	<option <?php if( $sort == 'title'): ?> selected="selected" <?php endif; ?> value="title"><?php echo e(trans('admin.sort_title')); ?></option>
					  	<option <?php if( $sort == 'likes'): ?> selected="selected" <?php endif; ?> value="likes"><?php echo e(trans('admin.sort_likes')); ?></option>
					  	<option <?php if( $sort == 'downloads'): ?> selected="selected" <?php endif; ?> value="downloads"><?php echo e(trans('admin.sort_downloads')); ?></option>
	                  </select>
	                  </form><!-- form -->
                  <div class="box-tools">
                 
                    <!-- form -->
                    <form role="search" autocomplete="off" action="<?php echo e(url('panel/admin/images')); ?>" method="get">
	                 <div class="input-group input-group-sm" style="width: 150px;">
	                  <input type="text" name="q" class="form-control pull-right" placeholder="Search">
	
	                  <div class="input-group-btn">
	                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
	                  </div>
	                </div>
                </form><!-- form -->
                  </div>
                  <?php endif; ?>
                  
                </div><!-- /.box-header -->
                
                
		
                <div class="box-body table-responsive no-padding">
                  <table class="table table-hover">
               <tbody>

               	<?php if( $data->total() !=  0 && $data->count() != 0 ): ?>
                   <tr>
                      <th class="active">ID</th>
                      <th class="active"><?php echo e(trans('misc.thumbnail')); ?></th>
                      <th class="active"><?php echo e(trans('admin.title')); ?></th>
                      <th class="active"><?php echo e(trans('misc.uploaded_by')); ?></th>
                      <th class="active"><?php echo e(trans('misc.likes')); ?></th>
                      <th class="active"><?php echo e(trans('misc.downloads')); ?></th>
                      <th class="active"><?php echo e(trans('admin.date')); ?></th>
                      <th class="active"><?php echo e(trans('admin.status')); ?></th>
                      <th class="active"><?php echo e(trans('admin.actions')); ?></th>
                    </tr>
                  
                  <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                    <tr>
                      <td><?php echo e($image->id); ?></td>
                      <td><img src="<?php echo e(asset('public/uploads/thumbnail').'/'.$image->thumbnail); ?>" width="50" /></td>
                      <td><a href="<?php echo e(url('photo', $image->id)); ?>" title="<?php echo e($image->title); ?>" target="_blank"><?php echo e(str_limit($image->title, 10, '...')); ?> <i class="fa fa-external-link-square"></i></a></td>
                      <td><?php echo e($image->user()->username); ?></td>
                      <td><?php echo e($image->likes()->count()); ?></td>
                      <td><?php echo e($image->downloads()->count()); ?></td>
                      <td><?php echo e(App\Helper::formatDate($image->date)); ?></td>
                     
                     <?php if( $image->status == 'pending' ) {
                      			$mode    = 'warning';
								$_status = trans('admin.pending');
                      		} elseif( $image->status == 'active' ) {
                      			$mode = 'success';
								$_status = trans('admin.active');
							}
                      		
                      		?> 
                      <td><span class="label label-<?php echo e($mode); ?>"><?php echo e($_status); ?></span></td>
                      <td>
                      	
                   <a href="<?php echo e(url('panel/admin/images', $image->id)); ?>" class="btn btn-success btn-xs padding-btn">
                      		<?php echo e(trans('admin.edit')); ?>

                      	</a> 
                      	
                   <?php echo Form::open([
			            'method' => 'POST',
			            'url' => 'panel/admin/images/delete',
			            'class' => 'displayInline'
				        ]); ?>

				        
				        <?php echo Form::hidden('id',$image->id );; ?>

	            	<?php echo Form::submit(trans('admin.delete'), ['data-url' => $image->id, 'class' => 'btn btn-danger btn-xs padding-btn actionDelete']); ?>

	        	<?php echo Form::close(); ?>


                      		
                      		</td>
                      
                    </tr><!-- /.TR -->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                    
                    <?php else: ?>
                    	<h3 class="text-center no-found"><?php echo e(trans('misc.no_results_found')); ?></h3>
                    	
                    	<?php if( isset( $query ) || isset( $sort )  ): ?>
                    	<div class="col-md-12 text-center padding-bottom-15">
                    		<a href="<?php echo e(url('panel/admin/images')); ?>" class="btn btn-sm btn-danger"><?php echo e(trans('auth.back')); ?></a>
                    	</div>
                    	
                    	<?php endif; ?>
                    <?php endif; ?>
                                        
                  </tbody>
                  
                  
                  </table>
                  
                  
                  
                </div><!-- /.box-body -->
              </div><!-- /.box -->
          <?php if( $data->count() != 0 ): ?>    
             <?php echo e($data->appends(['q' => $query, 'sort' => $sort])->links()); ?>

             <?php endif; ?>
            </div>
          </div>        	
        	
          <!-- Your Page Content Here -->

        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
	
<script type="text/javascript">

$(document).on('change','#sort',function(){
	 	$('#formSort').submit();
	 });
	 
$(".actionDelete").click(function(e) {
   	e.preventDefault();
   	   	
   	var element = $(this);
	var id     = element.attr('data-url');
	var form    = $(element).parents('form');
	
	element.blur();
	
	swal(
		{   title: "<?php echo e(trans('misc.delete_confirm')); ?>",  
		  type: "warning", 
		  showLoaderOnConfirm: true,
		  showCancelButton: true,   
		  confirmButtonColor: "#DD6B55",  
		   confirmButtonText: "<?php echo e(trans('misc.yes_confirm')); ?>",   
		   cancelButtonText: "<?php echo e(trans('misc.cancel_confirm')); ?>",  
		    closeOnConfirm: false, 
		    }, 
		    function(isConfirm){  
		    	 if (isConfirm) {   
		    	 	form.submit(); 
		    	 	//$('#form' + id).submit();
		    	 	}
		    	 });
		    	 
		    	 
		 });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>